USE OLAP
--List of countries
SELECT distinct country
FROM OLTP.dbo.countries

--Sales on 1/1/2016 or 2/1/2016
SELECT *
FROM OLTP.dbo.sales
WHERE date in ('01/01/2016','02/01/2016')

--How many sales do we have for each country
SELECT c.country,count(*) as number_of_sales
FROM OLTP.dbo.sales as s JOIN OLTP.dbo.countries as c
                         ON s.retailer_city=c.city
GROUP BY c.country

--'Compare the number of products sold on 1/1/2016 with 2/1/2016'?
SELECT date, sum(quantity_sold) as total_quantity_sold
FROM OLTP.dbo.sales
WHERE date in ('01/01/2016','02/01/2016')
GROUP BY date